<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fa fa-window"></i> <strong>Configurar Painel</strong></h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erros): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($erros); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form role="form" method="post" action="<?php echo e(route('painel.save')); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('put'); ?>

            <div class="form-group">
                <label>Nome</label>
                <input type="text" class="form-control" name="nome" disabled value="<?php echo e($painel->nome); ?>">
                <input type="hidden" name="id_painel" value="<?php echo e($painel->id_painel); ?>">
            </div>
            <div class="form-group">
                <label>Obs</label>
                <input type="text" class="form-control" name="obs" disabled value="<?php echo e($painel->obs); ?>">
            </div>
            <fieldset class="border p-3">
            <div class="form-group">
                <label>Habilitar video </label>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="player-checkbox" name="player" value="1" onclick="toggleVideoInput(this.checked)">
                    <label class="form-check-label" for="player-checkbox">Video no painel</label>
                </div>
            </div>
            
            <div class="form-group">
                <label>URL do Vídeo</label>
                <input type="text" class="form-control" name="url_midia" id="video-url" disabled value="<?php echo e($painel->url_midia ?? ''); ?>">
            </div>
            </fieldset>
            <br>
            <fieldset class="border p-3">
                <div class="form-group">
                    <label>Serviços do painel</label>
                    <table class="table table-bordered">
                        <?php if($meus_servicos): ?>
                            <?php $__currentLoopData = $meus_servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($meus->nome); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('painel.destivaServico', [$painel->id_painel, $meus->id_servico])); ?>" class="btn btn-sm btn-danger">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </table>
                </div>
            </fieldset>

            <hr>

            <div class="form-group">
                <label>Serviços</label>
                <div>
                    <?php if($servico): ?>
                        <?php $__currentLoopData = $servico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servicos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="id_servico[]" value="<?php echo e($servicos->id_servico); ?>">
                                <label class="form-check-label"><?php echo e($servicos->nome); ?></label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Salvar</button>
        </form>
    </div>
    <!-- /.card-body -->
</div>
<!-- /.card -->
<script>
    function toggleVideoInput(enable) {
        const videoUrlInput = document.getElementById('video-url');
        videoUrlInput.disabled = !enable;
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.admin1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\eFila\resources\views/painel/config.blade.php ENDPATH**/ ?>