<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="icon-folder-3"></i> <strong>Empresas</strong></h3>
        <div class="card-tools">
            <a href="<?php echo e(route('servicos.create')); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> Novo</a>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Razão Social</th>
                        <th>Proprietario</th>
                        <th>Email</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($empresas): ?>
                        <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($empresa->id_empresa); ?></td>
                                <td><?php echo e($empresa->nm_fantasia); ?></td>
                                <td><?php echo e($empresa->proprietario); ?></td>
                                <td><?php echo e($empresa->email); ?></td>
                                <td>
                                    <a class="btn btn-primary btn-sm" title="Configurar" href="<?php echo e(route('servico.prioridade', $empresa->id_empresa)); ?>"><i class="fas fa-cogs"></i></a>
                                    <a class="btn btn-danger btn-sm" title="Deletar" href="<?php echo e(route('servico.delete', $empresa->id_empresa)); ?>"><i class="fa fa-solid fa-trash"></i></a>
                                    <a class="btn btn-warning btn-sm" title="Editar" href="<?php echo e(route('servicos.edit', $empresa->id_empresa)); ?>"><i class="fa fa-edit"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4">NENHUM CADASTRO</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        
        <div class="row">
            <div class="col-md-6">
                <p>Página Atual: <?php echo e($empresas->currentPage('pagination::simple-bootstrap-4')); ?> de <?php echo e($empresas->lastPage('pagination::simple-bootstrap-4')); ?></p>
            </div>
            <div class="col-md-6">
                <div class="float-right">
                    <?php echo e($empresas->links('pagination::simple-bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
    <!-- /.card-footer -->
</div>
<!-- /.card --><?php /**PATH C:\laragon\www\eFila\resources\views/admin/empresa/partials/table-empresa.blade.php ENDPATH**/ ?>