<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="icon-home-3"></i> <strong>Locais</strong></h3>
        <div class="card-tools">
            <a href="<?php echo e(route('local.create')); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> Novo</a>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($local): ?>
                        <?php $__currentLoopData = $local; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($locais->id_local); ?></td>
                                <td><?php echo e($locais->nome); ?></td>
                                <td>
                                    <a class="btn btn-danger btn-sm" title="Deletar" href="<?php echo e(route('local.delete', $locais->id_local)); ?>"><i class="fa fa-solid fa-trash"></i></a>
                                    <a class="btn btn-warning btn-sm" title="Editar" href="<?php echo e(route('local.edit', $locais->id_local)); ?>"><i class="fa fa-edit"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3">NENHUM CADASTRO</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="row">
            <div class="col-md-6">
                <p>Página Atual: <?php echo e($local->currentPage('pagination::simple-bootstrap-4')); ?> de <?php echo e($local->lastPage('pagination::simple-bootstrap-4')); ?></p>
            </div>
            <div class="col-md-6">
                <div class="float-right">
                    <?php echo e($local->links('pagination::simple-bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
    <!-- /.card-footer -->
</div>
<!-- /.card --><?php /**PATH C:\laragon\www\efila\resources\views/locais/partials/table-locais.blade.php ENDPATH**/ ?>