<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>eFila - Gerenciamento de Filas</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
        }
        header {
            background: linear-gradient(90deg, #007bff, #0056b3);
            color: white;
            padding: 40px 0;
        }
        header h1 {
            font-size: 2.5rem;
            font-weight: bold;
        }
        header p {
            font-size: 1.2rem;
        }
        .btn-primary {
            background-color: #007bff;
            border: none;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .section-divider {
            height: 50px;
            background: linear-gradient(90deg, #f4f4f9, #e9ecef);
            margin: 40px 0;
        }
        .pricing-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .pricing-card:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }
        .clients img {
            border: 3px solid #007bff;
            transition: transform 0.3s ease;
        }
        .clients img:hover {
            transform: scale(1.1);
        }
        footer {
            background-color: #333;
            color: white;
            padding: 20px 0;
        }
        .section-title {
            position: relative;
            display: inline-block;
            margin-bottom: 20px;
        }
        .section-title::after {
            content: '';
            position: absolute;
            width: 50px;
            height: 3px;
            background-color: #007bff;
            bottom: -5px;
            left: 50%;
            transform: translateX(-50%);
        }
        .icon {
            font-size: 2rem;
            color: #007bff;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <header class="text-center">
        <h1>Bem-vindo ao eFila</h1>
        <p>Transforme o atendimento da sua empresa com o melhor sistema de gerenciamento de filas</p>
        <a href="#planos" class="btn btn-light btn-lg mt-3">Veja nossos planos</a>
    </header>

    <div class="container my-5">
        <div class="text-center mb-5">
            <h2 class="section-title">Sobre o eFila</h2>
            <p>O <strong>eFila</strong> é um sistema inovador para gerenciamento de filas de atendimento por meio de senhas. Ele permite a emissão e o controle de senhas normais e preferenciais, garantindo um atendimento mais eficiente e organizado. Ideal para empresas que desejam melhorar a experiência de seus clientes e otimizar seus processos internos.</p>
            <p>Com o eFila, você pode reduzir o tempo de espera, organizar o fluxo de atendimento e oferecer um serviço mais profissional e ágil.</p>
        </div>
    </div>

    <div class="section-divider"></div>

    <div class="container my-5">
        <h2 class="section-title text-center mb-4">Veja o eFila em Ação</h2>
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="ratio ratio-16x9">
                    <iframe src="https://www.youtube.com/embed/EXEMPLO_VIDEO" title="Demonstração do eFila" allowfullscreen></iframe>
                </div>
            </div>
            <div class="col-md-6">
                <h3>Como o eFila pode transformar seu atendimento</h3>
                <p>Assista ao vídeo para ver como o <strong>eFila</strong> funciona na prática. Descubra como ele pode organizar o fluxo de atendimento, reduzir o tempo de espera e melhorar a experiência dos seus clientes.</p>
                <p>Com o eFila, sua empresa terá:</p>
                <ul>
                    <li>Atendimento mais rápido e eficiente</li>
                    <li>Organização de filas com senhas normais e preferenciais</li>
                    <li>Monitoramento em tempo real</li>
                    <li>Maior satisfação dos clientes</li>
                </ul>
                <a href="#planos" class="btn btn-primary btn-lg mt-3">Assine Agora</a>
            </div>
        </div>
    </div>

    <div class="section-divider"></div>

    <div class="container my-5">
        <h2 id="planos" class="section-title text-center mb-4">Planos e Preços</h2>
        <div class="row text-center">
            <div class="col-md-4">
                <div class="card pricing-card shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title text-primary">Básico</h3>
                        <p class="card-text">Ideal para pequenas empresas</p>
                        <p>1 Usuário</p>
                        <p>1 Local de Atendimento</p>
                        <p>1 Tela de Chamada</p>
                        <p class="price fs-4 fw-bold">R$29/mês</p>
                        <button class="btn btn-primary btn-lg">Assinar</button>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card pricing-card shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title text-primary">Profissional</h3>
                        <p class="card-text">Para empresas em crescimento</p>
                        <p>1 Usuário</p>
                        <p>1 Local de Atendimento</p>
                        <p>1 Tela de Chamada</p>
                        <p class="price fs-4 fw-bold">R$59/mês</p>
                        <button class="btn btn-primary btn-lg">Assinar</button>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card pricing-card shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title text-primary">Premium</h3>
                        <p class="card-text">Para grandes empresas</p>
                        <p>1 Usuário</p>
                        <p>1 Local de Atendimento</p>
                        <p>1 Tela de Chamada</p>
                        <p class="price fs-4 fw-bold">R$99/mês</p>
                        <button class="btn btn-primary btn-lg">Assinar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="section-divider"></div>

    <div class="container my-5">
        <h2 class="section-title text-center">Nossos Clientes</h2>
        <p class="text-center">Empresas que confiam no eFila:</p>
        <div class="row text-center clients">
            <div class="col-md-3">
                <img src="https://via.placeholder.com/150" alt="Cliente 1" class="img-fluid rounded-circle mb-2">
                <p>Cliente 1</p>
            </div>
            <div class="col-md-3">
                <img src="https://via.placeholder.com/150" alt="Cliente 2" class="img-fluid rounded-circle mb-2">
                <p>Cliente 2</p>
            </div>
            <div class="col-md-3">
                <img src="https://via.placeholder.com/150" alt="Cliente 3" class="img-fluid rounded-circle mb-2">
                <p>Cliente 3</p>
            </div>
            <div class="col-md-3">
                <img src="https://via.placeholder.com/150" alt="Cliente 4" class="img-fluid rounded-circle mb-2">
                <p>Cliente 4</p>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white text-center py-5">
        <div class="container">
            <div class="row">
                <!-- Sobre o sistema -->
                <div class="col-md-4 mb-4">
                    <h5 class="text-uppercase fw-bold">Sobre o eFila</h5>
                    <p>O eFila é um sistema inovador para gerenciamento de filas, ajudando empresas a oferecer um atendimento mais eficiente e organizado. Simplifique o atendimento e melhore a experiência dos seus clientes.</p>
                </div>
                <!-- Contato -->
                <div class="col-md-4 mb-4">
                    <h5 class="text-uppercase fw-bold">Contato</h5>
                    <ul class="list-unstyled">
                        <li>Email: <a href="mailto:suporte@efila.com" class="text-white text-decoration-none">suporte@efila.com</a></li>
                        <li>Telefone: <a href="tel:+551112345678" class="text-white text-decoration-none">(11) 1234-5678</a></li>
                        <li>WhatsApp: <a href="https://wa.me/5511987654321" target="_blank" class="text-white text-decoration-none">(11) 98765-4321</a></li>
                    </ul>
                </div>
                <!-- Localização -->
                <div class="col-md-4 mb-4">
                    <h5 class="text-uppercase fw-bold">Localização</h5>
                    <p>Rua Exemplo, 123<br>Bairro Centro<br>São Paulo, SP - Brasil</p>
                    <p><a href="https://www.google.com/maps" target="_blank" class="btn btn-outline-light btn-sm">Ver no mapa</a></p>
                </div>
            </div>
            <hr class="bg-light">
            <div class="row">
                <div class="col-md-12">
                    <p class="mb-0">&copy; 2025 eFila - Todos os direitos reservados</p>
                    <p class="small">Desenvolvido por <a href="#" class="text-white text-decoration-none">Sua Empresa</a></p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH C:\laragon\www\efila\resources\views/teste.blade.php ENDPATH**/ ?>