<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro - eFila</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1>eFila</h1>
            </div>
          <!--  <nav class="nav">
                <ul>
                    <li><a href="index.html#features">Funcionalidades</a></li>
                    <li><a href="index.html#how-it-works">Como Funciona</a></li>
                    <li><a href="index.html#pricing">Planos</a></li>
                    <li><a href="index.html#contact">Contato</a></li>
                </ul>
            -->
            </nav>
        </div>
    </header>

    <!-- Cadastro Section -->
    <section class="cadastro">
        <div class="container">
            <div class="cadastro-container">
                <div class="cadastro-header">
                    <h2 class="section-title">Cadastro</h2>
                    <p class="cadastro-subtitle">Preencha os dados abaixo para criar sua conta</p>
                </div>
                <form class="cadastro-form" id="cadastroForm">
                    <!-- Credenciais de Acesso -->
                    <div class="form-section">
                        <h3><i class="fas fa-user-lock"></i> Credenciais de Acesso</h3>
                        <div class="form-group">
                            <label for="usuario">Nome de Usuário</label>
                            <input type="text" id="usuario" name="usuario" placeholder="Escolha um nome de usuário" required>
                            <small class="form-help">Mínimo de 6 caracteres, pode conter letras e números</small>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="senha">Senha</label>
                                <div class="password-input">
                                    <input type="password" id="senha" name="senha" placeholder="Digite sua senha" required>
                                    <button type="button" class="toggle-password"><i class="fas fa-eye"></i></button>
                                </div>
                                <small class="form-help">Mínimo de 8 caracteres, incluindo letras e números</small>
                            </div>

                            <div class="form-group">
                                <label for="confirmarSenha">Confirmar Senha</label>
                                <div class="password-input">
                                    <input type="password" id="confirmarSenha" name="confirmarSenha" placeholder="Confirme sua senha" required>
                                    <button type="button" class="toggle-password"><i class="fas fa-eye"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Dados Pessoais/Empresariais -->
                    <div class="form-section">
                        <h3><i class="fas fa-user-tie"></i> Dados Pessoais/Empresariais</h3>
                        <div class="form-group">
                            <label for="tipoPessoa">Tipo de Cadastro</label>
                            <select id="tipoPessoa" name="tipoPessoa" required>
                                <option value="">Selecione...</option>
                                <option value="pf">Pessoa Física</option>
                                <option value="pj">Pessoa Jurídica</option>
                            </select>
                        </div>

                        <div class="form-group" id="cpfGroup">
                            <label for="cpf">CPF</label>
                            <input type="text" id="cpf" name="cpf" placeholder="000.000.000-00" required>
                        </div>

                        <div class="form-group" id="cnpjGroup" style="display: none;">
                            <label for="cnpj">CNPJ</label>
                            <input type="text" id="cnpj" name="cnpj" placeholder="00.000.000/0000-00">
                        </div>

                        <div class="form-group" id="razaoSocialGroup" style="display: none;">
                            <label for="razaoSocial">Razão Social</label>
                            <input type="text" id="razaoSocial" name="razaoSocial">
                        </div>

                        <div class="form-group">
                            <label for="nome">Nome Completo</label>
                            <input type="text" id="nome" name="nome" required>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="email">E-mail</label>
                                <input type="email" id="email" name="email" required>
                            </div>

                            <div class="form-group">
                                <label for="telefone">Telefone</label>
                                <input type="tel" id="telefone" name="telefone" required>
                            </div>
                        </div>
                    </div>

                    <!-- Endereço -->
                    <div class="form-section">
                        <h3><i class="fas fa-map-marker-alt"></i> Endereço</h3>
                        <div class="form-group">
                            <label for="cep">CEP</label>
                            <input type="text" id="cep" name="cep" required>
                            <small class="form-help">Digite o CEP para preencher automaticamente o endereço</small>
                        </div>

                        <div class="form-group">
                            <label for="logradouro">Logradouro</label>
                            <input type="text" id="logradouro" name="logradouro" required>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="numero">Número</label>
                                <input type="text" id="numero" name="numero" required>
                            </div>

                            <div class="form-group">
                                <label for="complemento">Complemento</label>
                                <input type="text" id="complemento" name="complemento">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="bairro">Bairro</label>
                            <input type="text" id="bairro" name="bairro" required>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="cidade">Cidade</label>
                                <input type="text" id="cidade" name="cidade" required>
                            </div>

                            <div class="form-group">
                                <label for="estado">Estado</label>
                                <select id="estado" name="estado" required>
                                    <option value="">Selecione...</option>
                                    <option value="AC">Acre</option>
                                    <option value="AL">Alagoas</option>
                                    <option value="AP">Amapá</option>
                                    <option value="AM">Amazonas</option>
                                    <option value="BA">Bahia</option>
                                    <option value="CE">Ceará</option>
                                    <option value="DF">Distrito Federal</option>
                                    <option value="ES">Espírito Santo</option>
                                    <option value="GO">Goiás</option>
                                    <option value="MA">Maranhão</option>
                                    <option value="MT">Mato Grosso</option>
                                    <option value="MS">Mato Grosso do Sul</option>
                                    <option value="MG">Minas Gerais</option>
                                    <option value="PA">Pará</option>
                                    <option value="PB">Paraíba</option>
                                    <option value="PR">Paraná</option>
                                    <option value="PE">Pernambuco</option>
                                    <option value="PI">Piauí</option>
                                    <option value="RJ">Rio de Janeiro</option>
                                    <option value="RN">Rio Grande do Norte</option>
                                    <option value="RS">Rio Grande do Sul</option>
                                    <option value="RO">Rondônia</option>
                                    <option value="RR">Roraima</option>
                                    <option value="SC">Santa Catarina</option>
                                    <option value="SP">São Paulo</option>
                                    <option value="SE">Sergipe</option>
                                    <option value="TO">Tocantins</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                        <a href="index.html" class="btn btn-secondary">Voltar</a>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/cadastro.js')); ?>"></script>
</body>
</html> <?php /**PATH C:\laragon\www\efila\resources\views/landing-page/cadastro.blade.php ENDPATH**/ ?>