<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fa fa-user"></i> <strong>Atendente</strong></h3>
        <div class="card-tools">
            <a href="<?php echo e(route('atendente.create')); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> Novo</a>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>CPF</th>
                        <th>Email</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($atendente): ?>
                        <?php $__currentLoopData = $atendente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atendentes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($atendentes['pessoa']->id_pessoa); ?></td>
                                <td><?php echo e($atendentes['pessoa']->nome); ?></td>
                                <td><?php echo e($atendentes['pessoa']->cpf); ?></td>
                                <td><?php echo e($atendentes['pessoa']->email); ?></td>
                                <td>
                                    <a class="btn btn-danger btn-sm" title="Deletar" href="<?php echo e(route('atendente.delete', $atendentes->id_atendente)); ?>"><i class="fa fa-solid fa-trash"></i></a>
                                    <a class="btn btn-warning btn-sm" title="Editar" href="<?php echo e(route('atendente.edit', $atendentes->id_atendente)); ?>"><i class="fa fa-edit"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5">NENHUM CADASTRO</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="row">
            <div class="col-md-6">
                <p>Página Atual: <?php echo e($atendente->currentPage('pagination::simple-bootstrap-4')); ?> de <?php echo e($atendente->lastPage('pagination::simple-bootstrap-4')); ?></p>
            </div>
            <div class="col-md-6">
                <div class="float-right">
                    <?php echo e($atendente->links('pagination::simple-bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
    <!-- /.card-footer -->
</div>
<!-- /.card --><?php /**PATH C:\laragon\www\eFila\resources\views/atendente/partials/table-atendente.blade.php ENDPATH**/ ?>