<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>eFila - Login</title>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css'>
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,400i,600,700&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css?family=Montserrat:400,800');

        * {
            box-sizing: border-box;
        }

        body {
            background: #fff url('<?php echo e(asset('assets/img/bg-login.png')); ?>') no-repeat;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            font-family: Nunito, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            height: 100vh;
            margin: -20px 0 50px;
        }

        .container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 14px 28px rgba(0, 0, 0, 0.25),
                0 10px 10px rgba(0, 0, 0, 0.22);
            position: relative;
            overflow: hidden;
            width: 768px;
            max-width: 100%;
            min-height: 480px;
            display: flex;
        }

        .image-container {
            flex: 1;
            background: url('<?php echo e(asset('assets/img/efila-login.png')); ?>') no-repeat center center;
            background-size: cover;
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;
        }

        .form-container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            padding: 0 50px;
            text-align: center;
        }

        input {
            border: 1px solid lightgray;
            padding: 12px 15px;
            margin: 8px 0;
            width: 100%;
            border-radius: 3px;
            font-size: 15px;
            color: grey;
            height: 50px;
        }

        input:focus {
            outline: none;
        }

        button {
            border-radius: 20px;
            border: 1px solid #17A2B8;
            background-color: #17A2B8;
            color: #FFFFFF;
            font-size: 12px;
            font-weight: bold;
            padding: 12px 45px;
            letter-spacing: 1px;
            text-transform: uppercase;
            transition: transform 80ms ease-in;
        }
        .error-messages {
    color: #dc2626; /* Vermelho */
    font-size: 14px; /* Tamanho do texto */
    margin-top: 8px;
    list-style: none; /* Remove os marcadores da lista */
    padding: 0;
}
        button:active {
            transform: scale(0.95);
        }

        button:focus {
            outline: none;
        }

        .logo {
            width: 130px;
            margin-bottom: 20px;
        }

        .seguro {
            width: 25px;
        }

        .seguro1 {
            font-size: 14px;
            color: #858585;
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- Imagem na lateral esquerda -->
        <div class="image-container"></div>
              <!-- Formulário de Login -->
        <div class="form-container">
            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <a class="navbar-brand navbar-brand-dynamic-color fade-page" href="#">
                    <img class="logo" id="logo" alt="eFila" src="https://cerradoclound.com.br/public/uploads/file-9.png">
                </a>
                <input type="email" id="email" name="email" placeholder="Digite seu Email" required autofocus />
                <input type="password" id="password" name="password" placeholder="Digite sua Senha" required />
                <div id="div-mostrar-senha">
                    <input type="checkbox" style="width: 14px; float: left; margin-left: 150px; margin-top: -15px; margin-bottom: 0px" id="input-checkbox-mostrar-senha" onclick="mostrarSenha()" />
                    <label for="input-checkbox-mostrar-senha" style="font-size: 14px; padding-left: 3px">Mostrar senha</label>
                </div>
                <button type="submit" class="btn btn-primary" style="margin-top: 5px; width: 100%; border-radius: 5px">
                    <i class="fas fa-sign-in-alt"></i> ACESSAR O SISTEMA
                </button>
                <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('email'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('email')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('password'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('password')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>  
                        <br>
                <a class="seguro1">
                    <img class="seguro" alt="eFila" src="https://app.nxsistemas.com.br/assets/img/bloqueado.png">
                    <br>Sistema Monitorado por IP e Registrado Coordenadas de Acesso.
                    <br>
                    <b id="b-versao-do-sistema" style="font-size: 13px;">Versão: 1.0.0</b>
                </a>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function mostrarSenha() {
            const check = document.getElementById('input-checkbox-mostrar-senha').checked;
            const passwordInput = document.getElementById('password');
            passwordInput.type = check ? 'text' : 'password';
        }
    </script>
</body>
</html><?php /**PATH C:\laragon\www\eFila\resources\views/auth/login.blade.php ENDPATH**/ ?>