<?php

namespace App\Http\Controllers;

use App\Http\Requests\PlanoRequest;
use App\Models\Plano;
use Illuminate\Http\Request;

class PlanoController extends Controller
{

    
    public $titulo;
    public $subtilulo;
    public $controller;
   /**
    * Display a listing of the resource.
    */
   public function __construct()


   {
      $this->titulo='Criar novo plano';
      $this->subtilulo='Planos';
        $this->controller='admin.plano';


   }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {   
        $data=[
        'titulo'=>$this->titulo,
            'subtitulo'=>$this->subtilulo,
            'controller'=>$this->controller
        ];
        return view('admin.plano.create',$data);
       
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PlanoRequest $request)
    {        
     
        $plano = new Plano();
        $plano->nome=$request->nome;
        $plano->valor=$request->valor;
        $plano->qtd_tela_touch=$request->qtd_tela_touch;
        $plano->qtd_usuario=$request->qtd_usuario;
        $plano->qtd_tela_chamada=$request->qtd_tela_chamada;
       
       
        $plano->save();
        return redirect()->route('admin.plano')->with('success','Plano cadastrado com sucesso!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
