<!-- filepath: resources/views/components/video-embed.blade.php -->
<div class="video-container" style="position: relative;   margin: 0 auto;">
    <?php if($type === 'youtube'): ?>
        <!-- Embed YouTube Video -->
        <iframe 
            src="https://www.youtube.com/embed/<?php echo e($videoId); ?>?enablejsapi&autoplay=1" 
            frameborder="0" 
            allow="autoplay; encrypted-media" 
            allowfullscreen 
            style="width: 100%; height: 100%; ">
        </iframe>
    <?php elseif($type === 'vimeo'): ?>
        <!-- Embed Vimeo Video -->
        <iframe 
            src="https://player.vimeo.com/video/<?php echo e($videoId); ?>" 
            frameborder="0" 
            allow="autoplay; fullscreen" 
            allowfullscreen 
            style="width: 100%; height: <?php echo e($height ?? '450px'); ?>;">
        </iframe>
    <?php elseif($type === 'm3u8' || $type === 'mp4'): ?>
        <!-- Embed HTML5 Video -->
        <video 
            controls 
            autoplay 
            style="width: 100%; height: <?php echo e($height ?? '450px'); ?>;">
            <source src="<?php echo e($videoUrl); ?>" type="<?php echo e($type === 'm3u8' ? 'application/x-mpegURL' : 'video/mp4'); ?>">
            Your browser does not support the video tag.
        </video>
    <?php else: ?>
        <p>Unsupported video type.</p>
    <?php endif; ?>
</div><?php /**PATH C:\laragon\www\efila\resources\views/components/video-playlist.blade.php ENDPATH**/ ?>