<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>eFila - Sistema Inteligente de Gestão de Filas</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <!-- Header -->
    <header class="header">
        <div class="container">
            <div class="logo">
                <h1>eFila</h1>
            </div>
            <nav class="nav">
                <ul>
                    <li><a href="#features">Funcionalidades</a></li>
                    <li><a href="#how-it-works">Como Funciona</a></li>
                    <li><a href="#pricing">Planos</a></li>
                    <li><a href="#contact">Contato</a></li>
                </ul>
            </nav>
            <div class="cta-button">
                <a href="https://efila.cerradoclound.com.br" class="btn btn-primary">Acessar Sistema</a>
            </div>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Gestão de Filas Inteligente e Eficiente</h1>
                <p>Otimize o atendimento da sua empresa com o eFila, o sistema completo para gestão de filas e senhas.
                </p>
                <div class="hero-buttons">
                    <a href="#pricing" class="btn btn-primary">Conhecer Planos</a>
                    <a href="#how-it-works" class="btn btn-secondary">Ver Demonstração</a>
                </div>
            </div>
            <div class="hero-image">
                <div class="carousel-container">
                    <div class="carousel">
                        <div class="carousel-item active">
                            <img src="<?php echo e(asset('assets/img/efila.png')); ?>" alt="Dashboard eFila">
                        </div>
                        <div class="carousel-item">
                            <img src="<?php echo e(asset('assets/img/efila1.png')); ?>" alt="Painel de Chamada">
                        </div>
                        <div class="carousel-item">
                            <img src="<?php echo e(asset('assets/img/efila2.png')); ?>" alt="Relatórios">
                        </div>
                        <div class="carousel-item">
                            <img src="<?php echo e(asset('assets/img/efila3.png')); ?>" alt="Reos">
                        </div>

                    </div>
                    <button class="carousel-control prev" aria-label="Anterior">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button class="carousel-control next" aria-label="Próximo">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                    <div class="carousel-indicators">
                        <button class="indicator active" aria-label="Slide 1"></button>
                        <button class="indicator" aria-label="Slide 2"></button>
                        <button class="indicator" aria-label="Slide 3"></button>
                        <button class="indicator" aria-label="Slide 4"></button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features">
        <div class="container">
            <h2 class="section-title">Funcionalidades Principais</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <i class="fas fa-ticket-alt"></i>
                    <h3>Emissão de Senhas</h3>
                    <p>Sistema inteligente de emissão de senhas com prioridades e categorias personalizáveis.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-tv"></i>
                    <h3>Painéis de Chamada</h3>
                    <p>Painéis digitais para exibição de senhas e informações em tempo real.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-chart-line"></i>
                    <h3>Relatórios Avançados</h3>
                    <p>Análise completa de dados e métricas de atendimento.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-mobile-alt"></i>
                    <h3>Aplicativo Móvel</h3>
                    <p>Controle total do sistema através do seu smartphone.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Demonstração Section -->
    <section class="demonstracao" id="demonstracao">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Veja o eFila em Ação</h2>
                <p class="section-subtitle">Assista ao vídeo e conheça como o eFila pode transformar a gestão de filas
                    do seu negócio</p>
            </div>
            <div class="video-container">
                <div class="video-wrapper">
                    <iframe src="https://www.youtube.com/embed/SEU_VIDEO_ID" title="Demonstração do eFila"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen>
                    </iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works Section -->
    <section id="how-it-works" class="how-it-works">
        <div class="container">
            <h2 class="section-title">Como Funciona</h2>
            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <h3>Emissão de Senha</h3>
                    <p>O cliente recebe uma senha através do terminal ou aplicativo.</p>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <h3>Chamada Inteligente</h3>
                    <p>O sistema gerencia automaticamente a ordem de chamada.</p>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <h3>Atendimento</h3>
                    <p>O atendente recebe a senha e inicia o atendimento.</p>
                </div>
                <div class="step">
                    <div class="step-number">4</div>
                    <h3>Relatório</h3>
                    <p>Geração automática de relatórios de atendimento.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section id="pricing" class="pricing">
        <div class="container">
            <h2 class="section-title">Planos e Preços</h2>
            <div class="pricing-grid">
                <?php if (isset($component)) { $__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.pricing-card','data' => ['title' => 'Básico','price' => 'R$ 99/mês','features' => [
                    '1 Terminal de Atendimento',
                    '1 Painel de Chamada',
                    'Relatórios Básicos',
                    'Suporte por Email',
                ],'link' => '/cadastro']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('pricing-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Básico','price' => 'R$ 99/mês','features' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                    '1 Terminal de Atendimento',
                    '1 Painel de Chamada',
                    'Relatórios Básicos',
                    'Suporte por Email',
                ]),'link' => '/cadastro']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa)): ?>
<?php $attributes = $__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa; ?>
<?php unset($__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa)): ?>
<?php $component = $__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa; ?>
<?php unset($__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa); ?>
<?php endif; ?>
                
                <?php if (isset($component)) { $__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.pricing-card','data' => ['title' => 'Intermediario','price' => 'R$ 99/mês','features' => [
                    '1 Terminal de Atendimento',
                    '1 Painel de Chamada',
                    'Relatórios Básicos',
                    'Suporte por Email',
                ],'link' => '/cadastro']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('pricing-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Intermediario','price' => 'R$ 99/mês','features' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                    '1 Terminal de Atendimento',
                    '1 Painel de Chamada',
                    'Relatórios Básicos',
                    'Suporte por Email',
                ]),'link' => '/cadastro']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa)): ?>
<?php $attributes = $__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa; ?>
<?php unset($__attributesOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa)): ?>
<?php $component = $__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa; ?>
<?php unset($__componentOriginalfa5dda94d5e1211c6ad7dcc9e6648aaa); ?>
<?php endif; ?>
               
               
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section id="faq" class="faq">
        <div class="container">
            <h2 class="section-title">Perguntas Frequentes</h2>
            <div class="faq-container">
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Como funciona o sistema eFila?</h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p>O eFila é um sistema completo de gestão de filas que permite a emissão de senhas, controle de
                            atendimento e geração de relatórios. O sistema pode ser acessado através de computadores,
                            tablets ou smartphones, oferecendo flexibilidade total para sua operação.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Quais são os requisitos para usar o sistema?</h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p>O eFila é um sistema web-based, portanto, só precisa de um navegador atualizado e conexão com
                            a internet. Não é necessário instalar nenhum software adicional. Para os painéis de chamada,
                            recomendamos o uso de TVs ou monitores com entrada HDMI.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Posso personalizar o sistema para minha empresa?</h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Sim! O eFila oferece diversas opções de personalização, incluindo cores, logos, tipos de
                            senhas, prioridades e categorias de atendimento. No plano Empresarial, você pode até mesmo
                            integrar o sistema com outros softwares da sua empresa.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Como é feito o suporte técnico?</h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Oferecemos suporte por email para o plano Básico, suporte prioritário para o plano
                            Profissional e suporte 24/7 para o plano Empresarial. Além disso, disponibilizamos uma base
                            de conhecimento online com tutoriais e documentação completa.</p>
                    </div>
                </div>
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Posso testar o sistema antes de assinar?</h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Sim! Oferecemos uma versão de demonstração gratuita por 7 dias. Durante este período, você
                            terá acesso a todas as funcionalidades do plano Profissional para testar o sistema em sua
                            operação real.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="contact">
        <div class="container">
            <h2 class="section-title">Entre em Contato</h2>
            <div class="contact-grid">
                <div class="contact-info">
                    <div class="contact-item">
                        <i class="fas fa-envelope"></i>
                        <p>contato@efila.com.br</p>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-phone"></i>
                        <p>(62) 99999-9999</p>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <p>Goiânia - GO</p>
                    </div>
                </div>
                <form class="contact-form">
                    <input type="text" placeholder="Nome" required>
                    <input type="email" placeholder="Email" required>
                    <input type="tel" placeholder="Telefone">
                    <textarea placeholder="Mensagem" required></textarea>
                    <button type="submit" class="btn btn-primary">Enviar Mensagem</button>
                </form>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    <h2>eFila</h2>
                    <p>Sistema Inteligente de Gestão de Filas</p>
                </div>
                <div class="footer-links">
                    <h3>Links Rápidos</h3>
                    <ul>
                        <li><a href="#features">Funcionalidades</a></li>
                        <li><a href="#how-it-works">Como Funciona</a></li>
                        <li><a href="#pricing">Planos</a></li>
                        <li><a href="#contact">Contato</a></li>
                    </ul>
                </div>
                <div class="footer-social">
                    <h3>Redes Sociais</h3>
                    <div class="social-icons">
                        <a href="#"><i class="fab fa-facebook"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-linkedin"></i></a>
                        <a href="#"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 eFila. Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\laragon\www\eFila\resources\views/landing-page/teste.blade.php ENDPATH**/ ?>