<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="icon-window"></i> <strong>Painel</strong> Touch</h3>
        <div class="card-tools">
            <a href="<?php echo e(route('touch.create')); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> Novo</a>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Observação</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($painel): ?>
                        <?php $__currentLoopData = $painel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paineis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($paineis->id_touch); ?></td>
                                <td><?php echo e($paineis->nome); ?></td>
                                <td><?php echo e($paineis->obs); ?></td>
                                <td>
                                    <a class="btn btn-info btn-sm" target="_blank" title="Abrir painel" href="<?php echo e(route('touch.show', $paineis->id_touch)); ?>"><i class="fa fa-solid fa-desktop"></i></a>
                                    <a class="btn btn-danger btn-sm" title="Deletar" href="<?php echo e(route('touch.desativarPainel', $paineis->id_touch)); ?>"><i class="fa fa-solid fa-trash"></i></a>
                                    <a class="btn btn-primary btn-sm" title="Configurar" href="<?php echo e(route('touch.config', $paineis->id_touch)); ?>"><i class="fas fa-cogs"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4">NENHUM CADASTRO</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="row">
            <div class="col-md-6">
                <p>Página Atual: <?php echo e($painel->currentPage('pagination::simple-bootstrap-4')); ?> de <?php echo e($painel->lastPage('pagination::simple-bootstrap-4')); ?></p>
            </div>
            <div class="col-md-6">
                <div class="float-right">
                    <?php echo e($painel->links('pagination::simple-bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
    <!-- /.card-footer -->
</div>
<!-- /.card --><?php /**PATH C:\laragon\www\efila\resources\views/touch/partials/table-touch.blade.php ENDPATH**/ ?>