<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="icon-window"></i> <strong>Contadores</strong></h3>
        <div class="card-tools">
           
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="table-responsive">
            <table class="table  table-striped">
                <thead>
                    <tr>
                        <th>ID servico</th>
                        <th>Servico</th>
                        <th>Sigla</th>
                        <th>Contador</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @if ($contadores)
                     
                        @foreach ($contadores as $contador)
                            <tr>
                                
                                <td>{{ $contador->id_contador  }}</td>
                                <td>{{ $contador->servico->nome }}</td>
                                <td>{{ $contador->servico->sigla }}</td>
                                <td><span class="badge badge-info right">{{ $contador->numero }}</span></td>
                                <td>
                                    <a class="btn btn-danger btn-sm" title="Resetar contador" href="{{ route('triagem.resetServico', $contador->id_contador) }}"><i class="fa fa-redo"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="5">NENHUM CADASTRO</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="row">
            <div class="col-md-6">
                <p>Página Atual: {{ $contadores->currentPage('pagination::simple-bootstrap-4') }} de {{ $contadores->lastPage('pagination::simple-bootstrap-4') }}</p>
            </div>
            <div class="col-md-6">
                <div class="float-right">
                    {{ $contadores->links('pagination::simple-bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>
    <!-- /.card-footer -->
</div>
<!-- /.card -->