@extends('templates.admin')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fa fa-cogs"></i> <strong>Criar Serviço</strong></h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $erros)
                        <li>{{ $erros }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form role="form" method="post" action="{{ route('admin.plano.store') }}" class="bv-form">
            @csrf
       
            <div class="form-group">
                <label>Nome do Plano</label>
                <input type="text" class="form-control" name="nome" value="{{ old('nome') }}">
            </div>
            <div class="form-group">
                <label>Qtd de Usuarios</label>
                <input type="number" class="form-control" name="qtd_usuario" value="{{ old('sigla') }}">
            </div>
            <div class="form-group">
                <label>Qtd de Tela de Atendimento</label>
                <input type="number" class="form-control" name="qtd_tela_touch" value="{{ old('sigla') }}">
            </div>
            <div class="form-group">
                <label>Qtd de Tela de Serviços</label>
                <input type="number" class="form-control" name="qtd_servico" value="{{ old('sigla') }}">
            </div>
            <div class="form-group">
                <label>Qtd de Tela de Chamadas</label>
                <input type="number" class="form-control" name="qtd_tela_chamada" value="{{ old('sigla') }}">
            </div>
          
            <div class="form-group">
                <label>Valor</label>
                <input type="text" class="form-control" name="valor" value="{{ old('sigla') }}">
            </div>
            

            <button type="submit" class="btn btn-primary">Salvar</button>
        </form>
    </div>
    <!-- /.card-body -->
</div>
<!-- /.card -->
@endsection