// Máscaras para os campos
document.addEventListener('DOMContentLoaded', function() {
    // Máscara para CPF
    const cpfInput = document.getElementById('cpf');
    if (cpfInput) {
        cpfInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            e.target.value = value;
        });
    }

    // Máscara para CNPJ
    const cnpjInput = document.getElementById('cnpj');
    if (cnpjInput) {
        cnpjInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/^(\d{2})(\d)/, '$1.$2');
            value = value.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
            value = value.replace(/\.(\d{3})(\d)/, '.$1/$2');
            value = value.replace(/(\d{4})(\d)/, '$1-$2');
            e.target.value = value;
        });
    }

    // Máscara para Telefone
    const telefoneInput = document.getElementById('telefone');
    if (telefoneInput) {
        telefoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                value = value.replace(/(\d{2})(\d)/, '($1) $2');
                value = value.replace(/(\d{5})(\d)/, '$1-$2');
            }
            e.target.value = value;
        });
    }

    // Máscara para CEP
    const cepInput = document.getElementById('cep');
    if (cepInput) {
        cepInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/^(\d{5})(\d)/, '$1-$2');
            e.target.value = value;
        });

        // Buscar endereço pelo CEP
        cepInput.addEventListener('blur', function(e) {
            const cep = e.target.value.replace(/\D/g, '');
            if (cep.length === 8) {
                fetch(`https://viacep.com.br/ws/${cep}/json/`)
                    .then(response => response.json())
                    .then(data => {
                        if (!data.erro) {
                            document.getElementById('logradouro').value = data.logradouro;
                            document.getElementById('bairro').value = data.bairro;
                            document.getElementById('cidade').value = data.localidade;
                            document.getElementById('estado').value = data.uf;
                        }
                    })
                    .catch(error => console.error('Erro ao buscar CEP:', error));
            }
        });
    }

    // Alternar entre CPF e CNPJ
    const tipoPessoaSelect = document.getElementById('tipoPessoa');
    if (tipoPessoaSelect) {
        tipoPessoaSelect.addEventListener('change', function(e) {
            const cpfGroup = document.getElementById('cpfGroup');
            const cnpjGroup = document.getElementById('cnpjGroup');
            const razaoSocialGroup = document.getElementById('razaoSocialGroup');

            if (e.target.value === 'pf') {
                cpfGroup.style.display = 'block';
                cnpjGroup.style.display = 'none';
                razaoSocialGroup.style.display = 'none';
                document.getElementById('cpf').required = true;
                document.getElementById('cnpj').required = false;
                document.getElementById('razaoSocial').required = false;
            } else if (e.target.value === 'pj') {
                cpfGroup.style.display = 'none';
                cnpjGroup.style.display = 'block';
                razaoSocialGroup.style.display = 'block';
                document.getElementById('cpf').required = false;
                document.getElementById('cnpj').required = true;
                document.getElementById('razaoSocial').required = true;
            }
        });
    }

    // Validação do formulário
    const form = document.getElementById('cadastroForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();

            // Validação básica
            let isValid = true;
            const requiredFields = form.querySelectorAll('[required]');
            
            requiredFields.forEach(field => {
                if (!field.value) {
                    isValid = false;
                    field.classList.add('error');
                } else {
                    field.classList.remove('error');
                }
            });

            if (isValid) {
                // Aqui você pode adicionar o código para enviar os dados para o servidor
                const formData = new FormData(form);
                const data = Object.fromEntries(formData);
                console.log('Dados do formulário:', data);

                // Mostrar mensagem de sucesso
                alert('Cadastro realizado com sucesso!');
                form.reset();
            } else {
                alert('Por favor, preencha todos os campos obrigatórios.');
            }
        });
    }
}); 