<?php

namespace App\Http\Controllers;

use App\Http\Requests\ServicoRequest;
use App\Models\Contador;
use App\Models\Departamento;
use App\Models\Ordenacao;
use App\Models\Servico;
use Illuminate\Http\Request;

class ServicoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public $titulo;
    public $subtilulo;
    public $controller;


    public function __construct()


    {
        $this->titulo = 'Serviços';
        $this->subtilulo = 'Gerir Serviços';
        $this->controller = 'Servicos';
    }


    public function index()
    {




        $departamentos = Departamento::with('servicos')->get();



        $data = [
            "titulo" => $this->titulo,
            'subtitulo' => $this->subtilulo,
            'servicos' => Servico::where('status', '=', 'ativo')->paginate(5),
            'controller' => $this->controller,

        ];
        return view('servicos.list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {


        $data = [
            "titulo" => $this->titulo,
            'subtitulo' => $this->subtilulo,
            'departamentos' => Departamento::all(['nome']),
            'controller' => $this->controller
        ];
        return view('servicos.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ServicoRequest $request)
    {

        $request->validated();




        //validado agora é salvar
        $dados = [
            'nome' => $request->nome,
            'sigla' => $request->sigla,
            // 'departamento_id'=>$departamento->id_departamento

        ];



        Servico::create($dados);
        $id_servico = Servico::latest()->first();
        # se não existir um contador para o serviço escolhido criar
        $numero = Contador::where('servico_id', $id_servico)->first();
        //dd($id_servico->id_servico);
        // dd($numero);
        if ($numero == null) {
            $sn = [
                'servico_id' => $id_servico->id_servico,
                // 'departamento_id'=>$departamento->id_departamento,
                'numero' => 0
            ];
            Contador::create($sn);
            ###
            # CRIAR REGISTRO NO ORDENADOR
            $ordenador = [
                'servico_id' => $id_servico->id_servico
            ];
            Ordenacao::create($ordenador);
            #### ERRO AO criar  a ordenação
        }

        return redirect()->route('servicos')->with('success', 'Servico cadastrado com sucesso!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Servico $servico)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Servico $servico)
    {
        $data = [
            "titulo" => $this->titulo,
            'subtitulo' => $this->subtilulo,
            'servico' => $servico,
            'controller' => $this->controller
            //'departamentos'=>Departamento::all()

        ];
        return view('servicos.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ServicoRequest $request, Servico $servico)
    {
        $request->validated();
        // $departamento = Departamento::where('nome', $request->departamento)
        //->first(['id_departamento']);




        //validado agora é salvar
        $dados = [
            'nome' => $request->nome,
            'sigla' => $request->sigla,
            //'departamento_id'=>$departamento->id_departamento

        ];
        $id = ['id_servico' => $request->route('servico')];
        $servico->update($dados, $id);
        return redirect()->route('servicos')->with('success', 'Serviço Atualizado!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Servico $servico)
    {
        $servico->update(['status' => 'inativo']);
        return redirect()->route('servicos')->with('success', 'Serviço Deletado!');
    }
}
