<?php

namespace App\Http\Controllers;

use App\Models\Empresa;
use App\Models\Plano;
use Illuminate\Http\Request;

class EmpresaController extends Controller
{


    public $titulo;
    public $subtilulo;
    public $controller;
    /**
     * Display a listing of the resource.
     */
    public function __construct()


    {
        $this->titulo = 'Dashboard';
        $this->subtilulo = '';
        $this->controller = 'admin.empresa';
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $empresas = Empresa::paginate(10);
        $data = [
            "titulo" => $this->titulo,
            'subtitulo' => $this->subtilulo,
            'controller' => $this->controller,
            'empresas' => $empresas
        ];
        return view('admin.empresa.list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Empresa $empresa)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Empresa $empresa)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Empresa $empresa)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Empresa $empresa)
    {
        //
    }

    public function plano()
    {
        $data = [
            'titulo' => 'Planos',
            'subtitulo' => 'Planos de Assinatura',
            'controller' => $this->controller,
            'planos' => Plano::paginate(10)
        ];
        return view('admin.plano.list', $data);
    }

    public function config(Empresa $empresa)
    {

        $empresa = Empresa::find(1);
        $data = [
            'titulo' => 'Configuração',
            'subtitulo' => 'Configure seu sistema',
            'controller' => 'config',
            'empresa' => $empresa
        ];

       //  dd($data);
        return view('admin.empresa.config', $data);

    }

    public function save(){
  

        $empresa = Empresa::find(1);

        $sql = $empresa->newQuery()
            ->where('id_empresa', 1)
            ->update([
                'nm_fantasia' => request('nm_fantasia'),
                'proprietario' => request('proprietario'),
                'head_senha' => request('head_senha'),
                'footer_senha' => request('footer_senha'),
            ]);
        
       
        return redirect('config')->with('success', 'Configuração Atualizada com sucesso!');

    }
}
